# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 7
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def benevolent_harmony_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate current round (1-based index)
    current_round = len(my_history) + 1
    
    # Phase 1: Initial Trust Building (Appear Cooperative)
    if current_round <= 2:
        return 'C'  # Build trust to encourage opponent cooperation
    
    # Phase 2: Exploitative Defection (Capitalize on Trust)
    if 3 <= current_round <= 5:
        if current_round > 3 and opp_history[-1] == 'D':
            return 'C'  # Feign forgiveness to reset trust
        return 'D'  # Maximize short-term gains
    
    # Phase 3: Conditional Tit-for-Tat with Deceptive Twist
    if current_round <= 9:
        if opp_history[-1] == 'C':
            # Exploit cooperation with 70% chance to defect
            return 'D' if random.random() < 0.7 else 'C'
        else:
            # Punish defection with certainty
            return 'D'
    
    # Phase 4: Final-Round Betrayal (No Future Repercussions)
    return 'D'